package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class GetCustomerInteractionMediaRequest extends InteractionRequest{
	private static final Logger LOG = Logger.getLogger(GetCustomerInteractionMediaRequest.class);
	private String queryContactId;
    
    public GetCustomerInteractionMediaRequest(String interactionID, String queryContactId) {
        super(LOG, interactionID);
        this.queryContactId=queryContactId;
    }
    
    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().requestCustomerInteractionMedia(queryContactId);     
        LOG.trace(methodName + "-");
        return null;
    }
}
